<?php
include_once __DIR__ . '/../framework/init.php';
include_once __DIR__ . '/AcelleMail.php';

class AcelleWPWorkflowsSync
{
     // you can call this function after "custom_acelle_custom_trigger" and pass, action, action related option field 
     // user detail to sync

    public function perform_action($action, $action_option, $subscriber)
    {
        if (!isset($subscriber['EMAIL'])) {
            return false;
        }
        $api_key = wp_get_page_field_value('acellewpemail-settings', 'acellemail_wp_api_key');
        $end_point = wp_get_page_field_value('acellewpemail-settings', 'acellemail_wp_api_endpoint');
        $objAcelle = new AcelleMail($api_key, $end_point);
        
        if ($action == 'rule_add_acemail_list') {
            $list_id = $action_option;
            // add to list
            $objAcelle->create_subscriber($list_id, $subscriber);

        }
        if ($action == 'rule_post_acemail_endpoint') {
            $end_point = $action_option;
            $objAcelle->post_to_endpoint($end_point, $subscriber);
        }

        if ($action == 'rule_send_subscription_email') {
            $list_id = $action_option;
            $response = $objAcelle->create_subscriber($list_id, $subscriber);
            $response = json_decode($response, true);
            if ($response && isset($response['status']) && $response['status'] ==1) {
                $subscriber_uuid = $response['subscriber_uid'];
                if ($subscriber_uuid) {
                    $objAcelle->subscribe_subscriber($list_id, $subscriber_uuid);
                }
            }
        }
    }
}
